% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_feature_plots.R
\name{ssvFeatureBars}
\alias{ssvFeatureBars}
\title{bar plots of set sizes}
\usage{
ssvFeatureBars(
  object,
  show_counts = TRUE,
  bar_colors = NULL,
  counts_text_colors = NULL,
  return_data = FALSE,
  count_label_size = 8
)
}
\arguments{
\item{object}{passed to ssvMakeMembTable for conversion to membership table}

\item{show_counts}{logical.  should counts be displayed at the center of each
bar. default is TRUE}

\item{bar_colors}{character. rcolor or hex colors. default of NULL
uses RColorBrewer Dark2. Will repeat to match number of samples.}

\item{counts_text_colors}{character. rcolor or hex colors. default of NULL
uses RColorBrewer Dark2. Will repeat to match number of samples.}

\item{return_data}{logical.  If TRUE, return value is no longer ggplot and
is instead the data used to generate that plot. Default is FALSE.}

\item{count_label_size}{Font size bar count labels. Default is 8.}
}
\value{
ggplot of bar plot of set sizes
}
\description{
bar plots of set sizes
}
\examples{
data(CTCF_in_10a_overlaps_gr)
ssvFeatureBars(list(1:3, 2:6))
ssvFeatureBars(CTCF_in_10a_overlaps_gr, count_label_size = 10)
ssvFeatureBars(S4Vectors::mcols(CTCF_in_10a_overlaps_gr)[,2:3])
}
