% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_clusteringKmeans.R
\name{reorder_clusters_manual}
\alias{reorder_clusters_manual}
\title{reorder_clusters_manual}
\usage{
reorder_clusters_manual(
  clust_dt,
  manual_order,
  row_ = "id",
  cluster_ = "cluster_id",
  reapply_cluster_names = TRUE
)
}
\arguments{
\item{clust_dt}{data.table output from \code{\link{ssvSignalClustering}}}

\item{manual_order}{New order for clusters  Does not need to include all
clusters.  Any colors not included will be at the bottom in their original
order.}

\item{row_}{variable name mapped to row, likely id or gene name for ngs data.
Default is "id" and works with ssvFetch* output.}

\item{cluster_}{variable name to use for cluster info. Default is
"cluster_id".}

\item{reapply_cluster_names}{If TRUE, clusters will be renamed according to
new order instead of their original names. Default is TRUE.}
}
\value{
data.table as output from \code{\link{ssvSignalClustering}}
}
\description{
Manually applies a new order (top to bottom) for cluster using the result of
ssvSignalClustering.
}
\examples{
data(CTCF_in_10a_profiles_dt)
clust_dt = ssvSignalClustering(CTCF_in_10a_profiles_dt, nclust = 3)
new_dt = reorder_clusters_manual(clust_dt = clust_dt, manual_order = 2)
cowplot::plot_grid(
    ssvSignalHeatmap(clust_dt),
    ssvSignalHeatmap(new_dt)
)
}
