% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_fetch_signal.R
\name{prepare_fetch_GRanges_names}
\alias{prepare_fetch_GRanges_names}
\title{Creates a named version of input GRanges using the same method seqsetvis uses internally to ensure consistency.}
\usage{
prepare_fetch_GRanges_names(qgr, include_id = FALSE)
}
\arguments{
\item{qgr}{input GRanges object the set/check names on}

\item{include_id}{if TRUE, $id is retained. Default is FALSE.}
}
\value{
and named GRanges based on input qgr.
}
\description{
If $id is set, that value is used as name and duplicates are checked for.
}
\examples{
data(CTCF_in_10a_overlaps_gr)
qgr = CTCF_in_10a_overlaps_gr
names(qgr) = NULL
#default is to paste "region_" and iteration along length of qgr
prepare_fetch_GRanges_names(qgr)
#id gets used is already set
qgr$id = paste0("peak_", rev(seq_along(qgr)), "_of_", length(qgr))
prepare_fetch_GRanges_names(qgr)
}
