% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_signal_plots.R
\name{make_clustering_matrix}
\alias{make_clustering_matrix}
\title{make_clustering_matrix}
\usage{
make_clustering_matrix(
  tidy_dt,
  row_ = "id",
  column_ = "x",
  fill_ = "y",
  facet_ = "sample",
  max_rows = 500,
  max_cols = 100,
  clustering_col_min = -Inf,
  clustering_col_max = Inf,
  dcast_fill = NA,
  fun.aggregate = "mean"
)
}
\arguments{
\item{tidy_dt}{the tidy data.table to covert to a wide matrix.  Must have
entries for variables specified by row_, column_, fill_, and facet_.}

\item{row_}{variable name mapped to row, likely peak id or gene name for ngs
data}

\item{column_}{varaible mapped to column, likely bp position for ngs data}

\item{fill_}{numeric variable to map to fill}

\item{facet_}{variable name to facet horizontally by}

\item{max_rows}{for speed rows are sampled to 500 by default, use Inf to plot
full data}

\item{max_cols}{for speed columns are sampled to 100 by default, use Inf to
plot full data}

\item{clustering_col_min}{numeric minimum for col range considered when
clustering, default in -Inf}

\item{clustering_col_max}{numeric maximum for col range considered when
clustering, default in Inf}

\item{dcast_fill}{value to supply to dcast fill argument. default is NA.}

\item{fun.aggregate}{Function to aggregate when multiple values present for
facet_, row_, and column_. The
function should accept a single vector argument or be a character string
naming such a function.}
}
\value{
A wide matrix version of input tidy data.table
}
\description{
Create a wide matrix from a tidy data.table more suitable for clustering
methods
}
\examples{
data(CTCF_in_10a_profiles_dt)
mat = make_clustering_matrix(CTCF_in_10a_profiles_dt)
mat[1:5, 1:5]
}
