% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_fragLen.R
\name{fragLen_calcStranded}
\alias{fragLen_calcStranded}
\title{calculate fragLen from a bam file for specified regions}
\usage{
fragLen_calcStranded(
  bam_f,
  qgr,
  n_regions = 100,
  include_plot_in_output = FALSE,
  test_fragLen = seq(100, 400, 5),
  flip_strand = FALSE,
  ...
)
}
\arguments{
\item{bam_f}{character or BamFile. bam file to read from.
.bai index file must be in same directory}

\item{qgr}{GRanges.  used as which for ScanBamParam. Can be NULL if it's
REALLY important to load the entire bam, force_no_which = TRUE also required.}

\item{n_regions}{numeric (integer) it's generally overkill to pull all
regions at this stage and will slow calculation down.  Default is 100.}

\item{include_plot_in_output}{if TRUE ouptut is a list of fragLen and a
ggplot showing values considered by calculation. Default is FALSE.}

\item{test_fragLen}{numeric.  The set of fragment lenghts to gather
strand cross correlation for.}

\item{flip_strand}{boolean. if TRUE strands that reads align to are swapped.
This is typically only necessary if there was a mismatch between library
chemistry and aligner settings. Default is FALSE.}

\item{...}{passed to Rsamtools::ScanBamParam, can't be which or what.}
}
\value{
numeric fragment length
}
\description{
calculate fragLen from a bam file for specified regions
}
\examples{
data(CTCF_in_10a_overlaps_gr)
bam_file = system.file("extdata/test.bam",
    package = "seqsetvis")
qgr = CTCF_in_10a_overlaps_gr[1:5]
fragLen_calcStranded(bam_file, qgr)
#if plot is included, a list is returned, item 2 is the plot
fragLen_calcStranded(bam_file, qgr,
  include_plot_in_output = TRUE)[[2]]
}
