% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_signal_operations.R
\name{centerAtMax}
\alias{centerAtMax}
\title{centers profile of x and y.  default is to center by region but across all
samples.}
\usage{
centerAtMax(
  dt,
  x_ = "x",
  y_ = "y",
  by_ = "id",
  view_size = NULL,
  trim_to_valid = TRUE,
  check_by_dupes = TRUE,
  x_precision = 3,
  replace_x = TRUE
)
}
\arguments{
\item{dt}{data.table}

\item{x_}{the variable name of the x-values. default is 'x'}

\item{y_}{the variable name of the y-values default is 'y'}

\item{by_}{optionally, any variables that provide grouping to the data.
default is none.  see details.}

\item{view_size}{the size in \code{x_} to consider for finding the max
of \code{y_}.
if length(view_size) == 1, range will be c(-view_size, view_size).
if length(view_size) > 1, range will be range(view_size).
default value of NULL uses complete range of x.}

\item{trim_to_valid}{valid \code{x_} values are those with a set \code{y_}
value in all \code{by_} combinations}

\item{check_by_dupes}{default assumption is that there should be on set of
x_ for a by_ instance.
if this is not the case and you want to disable warnings about set this
to FALSE.}

\item{x_precision}{numerical precision of x, default is 3.}

\item{replace_x}{logical, default TRUE.
if TRUE x_ will be replaced with position relative to summit.
if FALSE x_ will be preserved and x_summitPosition added.}
}
\value{
data.table with x (or xnew if replace_x is FALSE) shifted such that
x = 0 matches the maximum y-value define by by_ grouping
}
\description{
\code{centerAtMax} locates the coordinate x of the maximum in y and shifts x
such that it is zero at max y.
}
\details{
character.  by_ controls at the level of the data centering is
applied.  If by_ is "" or NULL, a single max position will be determined
for the entire dataset.  If by is "id" (the default) then each region will be
centered individually across all samples.
}
\examples{
data(CTCF_in_10a_profiles_gr)
centerAtMax(CTCF_in_10a_profiles_gr, y_ = 'y', by_ = 'id',
  check_by_dupes = FALSE)
#it's a bit clearer what's happening with trimming disabled
#but results are less useful for heatmaps etc.
centerAtMax(CTCF_in_10a_profiles_gr, y_ = 'y', by_ = 'id',
  check_by_dupes = FALSE, trim_to_valid = FALSE)
#specify view_size to limit range of x values considered, prevents
#excessive data trimming.
centerAtMax(CTCF_in_10a_profiles_gr, y_ = 'y', view_size = 100, by_ = 'id',
check_by_dupes = FALSE)
}
