% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_normalization.R
\name{calc_norm_factors}
\alias{calc_norm_factors}
\title{calc_norm_factors}
\usage{
calc_norm_factors(
  full_dt,
  value_ = "y",
  cap_value_ = "y_cap_value",
  by1 = "id",
  by2 = "sample",
  aggFUN1 = max,
  aggFUN2 = function(x) quantile(x, 0.95)
)
}
\arguments{
\item{full_dt}{a data.table, as returned by ssvFetch*(..., return_data.table.
= TRUE)}

\item{value_}{character, attribute in full_dt to normalzie.}

\item{cap_value_}{character, new attribute name specifying values to cap to.}

\item{by1}{character vector, specifies attributes relevant to step 1.}

\item{by2}{character vector, specifies attributes relevant to step 1 and 2.}

\item{aggFUN1}{function called on value_ with by = c(by1, by2) in step 1.}

\item{aggFUN2}{function called on result of aggFUN1 with by = by2 in step 2.}
}
\value{
data.table mapping by2 to cap_value_.
}
\description{
Calculate normalization factors in a two step process:
}
\details{
\enumerate{
\item summarize every region for each sample (default summary function is max)
\item caclulate a value to cap each sample to based on regions (default is 95th
quantile).
}

The uderlying assumption here is that meaningful enrichment is present at the
majority of regions provided.  If prevalence varies by a specific factor, say
ChIP-seq targets with different characteristics - ie. when analyzing TSSes
for H3K4me3 and an infrequent transcription factor it is more appropriate to
specify appropriate quantile cutoffs per factor.
}
\examples{
data(CTCF_in_10a_profiles_dt)
calc_norm_factors(CTCF_in_10a_profiles_dt)
calc_norm_factors(CTCF_in_10a_profiles_dt,
  aggFUN1 = mean, aggFUN2 = function(x)quantile(x, .5))
}
