% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_normalization.R
\name{append_ynorm}
\alias{append_ynorm}
\title{append_ynorm}
\usage{
append_ynorm(
  full_dt,
  value_ = "y",
  cap_value_ = "y_cap_value",
  norm_value_ = "y_norm",
  by1 = "id",
  by2 = "sample",
  aggFUN1 = max,
  aggFUN2 = function(x) quantile(x, 0.95),
  cap_dt = NULL,
  do_not_cap = FALSE,
  do_not_scaleTo1 = FALSE,
  force_append = FALSE
)
}
\arguments{
\item{full_dt}{a data.table, as returned by ssvFetch*(..., return_data.table
= TRUE).}

\item{value_}{character, attribute in full_dt to normalzie.}

\item{cap_value_}{character, new attribute name specifying values to cap to.}

\item{norm_value_}{character, new attribute name specifying normalized values.}

\item{by1}{character vector, specifies attributes relevant to step 1.}

\item{by2}{character vector, specifies attributes relevant to step 1 and 2.}

\item{aggFUN1}{function called on value_ with by = c(by1, by2) in step 1.}

\item{aggFUN2}{function called on result of aggFUN1 with by = by2 in step 2.}

\item{cap_dt}{optionally, provide user generated by2 to cap_value_ mapping}

\item{do_not_cap}{if TRUE, normalized values are not capped to 1. Default is FALSE.}

\item{do_not_scaleTo1}{if TRUE, normalized values are not scaled to 1. Default is FALSE.}

\item{force_append}{if TRUE, any previous cap_value or norm_value is overridden. Default is FALSE.}
}
\value{
data.table, full_dt with cap_value_ and norm_value_ values appended.
}
\description{
see \code{\link{calc_norm_factors}} for normalization details.
}
\examples{
data(CTCF_in_10a_profiles_dt)
append_ynorm(CTCF_in_10a_profiles_dt)
append_ynorm(CTCF_in_10a_profiles_dt,
  aggFUN1 = mean, aggFUN2 = function(x)quantile(x, .5))
}
