% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reassortment.R
\name{hybrid_plot}
\alias{hybrid_plot}
\title{hyrid_plot}
\usage{
hybrid_plot(
  virus_info,
  flow_info,
  v_color = "darkgreen",
  v_fill = "steelblue",
  v_shape = "ellipse",
  l_color = "black",
  asp = 1,
  parse = FALSE,
  g_height = 0.65,
  g_width = 0.65,
  t_size = 3.88,
  t_color = "black"
)
}
\arguments{
\item{virus_info}{virus information}

\item{flow_info}{flow information}

\item{v_color}{the color of outer boundary of virus; can use expression (e.g. v_color=~Host) to color virus by specific variable}

\item{v_fill}{the color to fill viruses; can use expression (e.g. v_fill=~Host) to fill virus by specific variable}

\item{v_shape}{one of 'hexagon' or 'ellipse'}

\item{l_color}{color of the lines that indicate genetic flow}

\item{asp}{aspect ratio of the plotting device}

\item{parse}{whether parse label, only works if 'label' and 'label_position' exist}

\item{g_height}{height of regions to plot gene segments relative to the virus}

\item{g_width}{width of gene segment relative to width of the virus (the hexagon)}

\item{t_size}{size of text label}

\item{t_color}{color of text label}
}
\value{
ggplot object
}
\description{
visualize virus reassortment events
}
\examples{
library(tibble)
n <- 8
virus_info <- tibble(id = 1:7,
x = c(rep(1990, 4), rep(2000, 2), 2009),
y = c(1,2,3,5, 1.5, 3, 4),
segment_color = list(rep('purple', n),
rep('red', n), rep('darkgreen', n), rep('lightgreen', n),
c('darkgreen', 'darkgreen', 'red', 'darkgreen', 'red', 'purple', 'red', 'purple'),
c('darkgreen', 'darkgreen', 'red', 'darkgreen', 'darkgreen', 'purple', 'red', 'purple'),
c('darkgreen', 'lightgreen', 'lightgreen', 'darkgreen', 'darkgreen', 'purple', 'red', 'purple')))

flow_info <- tibble(from = c(1,2,3,3,4,5,6), to = c(5,5,5,6,7,6,7))

hybrid_plot(virus_info, flow_info)

}
\author{
Guangchuang Yu
}
