% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reassortment.R
\name{geom_genotype}
\alias{geom_genotype}
\title{geom_genotype}
\usage{
geom_genotype(
  virus_info,
  v_color = "darkgreen",
  v_fill = "steelblue",
  v_shape = "ellipse",
  l_color = "black",
  asp = 1,
  g_height = 0.65,
  g_width = 0.65
)
}
\arguments{
\item{virus_info}{virus information}

\item{v_color}{the color of outer boundary of virus; can use expression (e.g. v_color=~Host) to color virus by specific variable}

\item{v_fill}{the color to fill viruses; can use expression (e.g. v_fill=~Host) to fill virus by specific variable}

\item{v_shape}{one of 'hexagon' or 'ellipse'}

\item{l_color}{color of the lines that indicate genetic flow}

\item{asp}{aspect ratio of the plotting device}

\item{g_height}{height of regions to plot gene segments relative to the virus}

\item{g_width}{width of gene segment relative to width of the virus (the hexagon)}
}
\value{
geom layer
}
\description{
geom layer of genotype
}
\examples{
library(tibble)
library(ggplot2)
n <- 8
virus_info <- tibble(id = 1:7,
x = c(rep(1990, 4), rep(2000, 2), 2009),
y = c(1,2,3,5, 1.5, 3, 4),
segment_color = list(rep('purple', n),
rep('red', n), rep('darkgreen', n), rep('lightgreen', n),
c('darkgreen', 'darkgreen', 'red', 'darkgreen', 'red', 'purple', 'red', 'purple'),
c('darkgreen', 'darkgreen', 'red', 'darkgreen', 'darkgreen', 'purple', 'red', 'purple'),
c('darkgreen', 'lightgreen', 'lightgreen', 'darkgreen', 'darkgreen', 'purple', 'red', 'purple')))
ggplot() + geom_genotype(virus_info)
}
\author{
Guangchuang Yu
}
