% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_profile.R
\name{read_profile}
\alias{read_profile}
\title{Read SNV profile}
\usage{
read_profile(file, sample_name = NULL)
}
\arguments{
\item{file}{The SNV profile to be read (path).}

\item{sample_name}{Sample name to be added; overrides profile sample if it
already exists (character).}
}
\value{
A data frame.
}
\description{
Read an SNV profile stored on disk.
}
\details{
This is a function for reading SNV profiles created from VCF
files that were stored on disk.
}
\examples{
# Path to test data
profile = system.file("extdata",
                      "test_1.profile.txt.gz",
                      package = "seqCAT")

# Read test profile
profile <- read_profile(profile)
}
