% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_cosmic.R
\name{read_cosmic}
\alias{read_cosmic}
\title{Read COSMIC data}
\usage{
read_cosmic(file_path, sample_name = NULL, primary_site = NULL)
}
\arguments{
\item{file_path}{The COSMIC data file path (path).}

\item{sample_name}{Subset the data on sample name (character).}

\item{primary_site}{Subset the data on primary tumour site (character).}
}
\value{
A dataframe with COSMIC SNVs.
}
\description{
Read COSMIC sample-specific mutational data.
}
\details{
This function reads the COSMIC data files (e.g.
"CosmicCLP_MutantExport.tsv.gz") and returns a GRanges object with all the
listed mutations for the specified sample, which can then be use in
downstream profile  comparisons. Only non-duplicated (gene-level) SNVs are
included in COSMIC profiles.
}
\examples{
# Path to COSMIC test data
file <- system.file("extdata",
                    "subset_CosmicCLP_MutantExport.tsv.gz",
                    package = "seqCAT")

# Read COSMIC test data for the HCT116 cell line
cosmic_hct116 <- read_cosmic(file, "HCT116")
}
