% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_variants.R
\name{filter_duplicates}
\alias{filter_duplicates}
\title{Variant de-duplication}
\usage{
filter_duplicates(data, filter_gd = TRUE, filter_pd = FALSE)
}
\arguments{
\item{data}{The dataframe containing the variant data to be filtered.}

\item{filter_gd}{Filter duplicate variants at the gene-level (boolean).}

\item{filter_pd}{Filter duplicate variants at the position-level (boolean).}
}
\value{
A data frame containing the filtered variants.
}
\description{
Filter duplicated variants.
}
\details{
This is a function for filtering duplicated variants either on the
 gene-level or the position-level.
}
\examples{
# Load test comparisons
data(test_profile_1)

# Filter variants
filtered_gene <- filter_duplicates(test_profile_1)
filtered_position <- filter_duplicates(test_profile_1, filter_pd = TRUE)
}
