% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgname.R
\name{arguments}
\alias{arguments}
\title{Documentation}
\arguments{
\item{y}{\strong{observations:}
numeric vector of length \code{n}}

\item{Y}{\strong{observations:}
numeric vector of length \code{n},
or numeric matrix with \code{n} rows (samples)
and \code{q} columns (variables)}

\item{z}{\strong{class labels:}
integer vector of length \code{n},
with entries \code{0}, \code{1} and \code{NA}}

\item{Z}{\strong{class labels:}
numeric vector of length \code{n},
or numeric matrix with \code{n} rows (samples)
and \code{p} columns (variables),
with entries \code{0} and \code{NA}}

\item{dist}{distributional assumption\strong{:}
character \code{"norm"} (Gaussian),
\code{"nbinom"} (negative bionomial),
or \code{"zinb"} (zero-inflated negative binomial)}

\item{phi}{dispersion parameters\strong{:}
numeric vector of length \code{q},
or \code{NULL}}

\item{pi}{zero-inflation parameter(s)\strong{:}
numeric vector of length \code{q},
or \code{NULL}}

\item{gamma}{offset\strong{:}
numeric vector of length \code{n},
or \code{NULL}}

\item{test}{resampling procedure\strong{:}
character \code{"perm"} (permutation) or
\code{"boot"} (parametric bootstrap),
or \code{NULL}}

\item{iter}{(maximum) number of resampling iterations \strong{:}
positive integer, or \code{NULL}}

\item{kind}{resampling accuracy\strong{:}
numeric between \code{0} and \code{1}, or \code{NULL}\strong{;}
all \code{p}-values above \code{kind} are approximate}

\item{starts}{restarts of the \code{EM} algorithm\strong{:}
positive integer (defaults to \code{1})}

\item{it.em}{(maximum) number of iterations in the \code{EM} algorithm\strong{:}
positive integer (defaults to \code{100})}

\item{epsilon}{convergence criterion for the \code{EM} algorithm\strong{:}
non-negative numeric (defaults to \code{1e-04})}

\item{debug}{verification of arguments\strong{:}
\code{TRUE} or \code{FALSE}}

\item{pass}{parameters for parametric bootstrap algorithm}

\item{...}{settings \code{EM} algorithm\strong{:}
\code{starts}, \code{it.em} and \code{epsilon}
(see \code{\link{arguments}})}
}
\description{
This page lists and describes all arguments
of the R package \code{\link{semisup}}.
}
\seealso{
Use \code{\link{mixtura}} for model fitting,
and \code{\link{scrutor}} for hypothesis testing.
All other functions of the R package \code{\link{semisup}}
are \code{\link{internal}}.
}
\keyword{internal}
