# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Calculate the value of the log-likelihood for given parameters
#'
#' @param vPatternList The list of possible mutation features (converted
#' to a vector)
#' @param vSparseCount The table showing (mutation feature, sample, the number
#' of mutation) (converted to a vector)
#' @param vF F (converted to a vector)
#' @param vQ Q (converted to a vector)
#' @param fdim a vector specifying the number of possible values for each
#' mutation signature
#' @param signatureNum the number of mutation signatures
#' @param sampleNum the number of cancer genomes
#' @param patternNum the number of possible combinations of all the mutation
#' features
#' @param samplePatternNum the number of possible combination of samples and
#' mutation patternns
#' @param isBackground the logical value showing whether a background mutaiton
#' features is included or not
#' @param vF0 a background mutaiton features
#' @return a value
getLogLikelihoodC <- function(vPatternList, vSparseCount, vF, vQ, fdim, signatureNum, sampleNum, patternNum, samplePatternNum, isBackground, vF0) {
    .Call('_selectKSigs_getLogLikelihoodC', PACKAGE = 'selectKSigs', vPatternList, vSparseCount, vF, vQ, fdim, signatureNum, sampleNum, patternNum, samplePatternNum, isBackground, vF0)
}

#' Convert the parameter Q so that turboEM can treat
#' 
#' @param vQ Q (converted to a vector)
#' @param signatureNum the number of mutation signatures
#' @param sampleNum the number of cancer genomes
#' @return a vector
convertToTurbo_Q <- function(vQ, signatureNum, sampleNum) {
    .Call('_selectKSigs_convertToTurbo_Q', PACKAGE = 'selectKSigs', vQ, signatureNum, sampleNum)
}

#' Convert the parameter F so that turboEM can treat
#' 
#' @param vF F (converted to a vector)
#' @param fdim a vector specifying the number of possible values for each 
#' mutation signature
#' @param signatureNum the number of mutation signatures
#' @param isBackground the logical value showing whether a background mutaiton 
#' features is included or not
#' @return a vector
convertToTurbo_F <- function(vF, fdim, signatureNum, isBackground) {
    .Call('_selectKSigs_convertToTurbo_F', PACKAGE = 'selectKSigs', vF, fdim, signatureNum, isBackground)
}

#' Restore the converted parameter Q for turboEM
#' 
#' @param turboQ Q (converted for turboEM)
#' @param signatureNum the number of mutation signatures
#' @param sampleNum the number of cancer genomes
#' @return a vector 
convertFromTurbo_Q <- function(turboQ, signatureNum, sampleNum) {
    .Call('_selectKSigs_convertFromTurbo_Q', PACKAGE = 'selectKSigs', turboQ, signatureNum, sampleNum)
}

#' Restore the converted parameter F for turboEM
#' 
#' @param turboF F (converted for turboEM)
#' @param fdim a vector specifying the number of possible values for each 
#' mutation signature
#' @param signatureNum the number of mutation signatures
#' @param isBackground the logical value showing whether a background mutaiton 
#' features is included or not
#' @return a vector
convertFromTurbo_F <- function(turboF, fdim, signatureNum, isBackground) {
    .Call('_selectKSigs_convertFromTurbo_F', PACKAGE = 'selectKSigs', turboF, fdim, signatureNum, isBackground)
}

