% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sechm.R
\name{sechm}
\alias{sechm}
\title{sechm}
\usage{
sechm(
  se,
  features,
  do.scale = FALSE,
  assayName = NULL,
  name = NULL,
  sortRowsOn = NULL,
  cluster_cols = FALSE,
  cluster_rows = NULL,
  toporder = NULL,
  hmcols = NULL,
  breaks = .getDef("breaks"),
  gaps_at = NULL,
  gaps_row = NULL,
  left_annotation = NULL,
  right_annotation = NULL,
  top_annotation = NULL,
  bottom_annotation = NULL,
  anno_colors = list(),
  show_rownames = NULL,
  show_colnames = FALSE,
  isMult = FALSE,
  show_heatmap_legend = !isMult,
  show_annotation_legend = TRUE,
  mark = NULL,
  na_col = "white",
  annorow_title_side = ifelse(show_colnames, "bottom", "top"),
  annocol_title_side = "right",
  includeMissing = FALSE,
  sort.method = "MDS_angle",
  ...
)
}
\arguments{
\item{se}{A \code{\link[SummarizedExperiment]{SummarizedExperiment-class}}.}

\item{features}{A vector of features (i.e. row names of `se`). Alternatively,
can be a list of feature sets, in which case these will be plotted as
different row chunks.}

\item{do.scale}{Logical; whether to scale rows (default FALSE).}

\item{assayName}{An optional vector of assayNames to use. The first available
will be used, or the first assay if NULL.}

\item{name}{The name of the heatmap, eventually appearing as title of the
color scale.}

\item{sortRowsOn}{Sort rows by MDS polar order using the specified columns
(default all)}

\item{cluster_cols}{Whether to cluster columns (default F)}

\item{cluster_rows}{Whether to cluster rows; default FALSE if
`do.sortRows=TRUE`.}

\item{toporder}{Optional vector of categories on which to supra-order when
sorting rows, or name of a `rowData` column to use for this purpose.}

\item{hmcols}{Colors for the heatmap.}

\item{breaks}{Breaks for the heatmap colors. Alternatively, symmetrical
breaks can be generated automatically by setting `breaks` to a numerical
value between 0 and 1. The value is passed as the `split.prop` argument to
the \code{\link{getBreaks}} function, and indicates the proportion of the
points to map to a linear scale, while the more extreme values will be
plotted on a quantile scale. `breaks=FALSE` will disable symmetrical scale
and quantile capping, while retaining automatic breaks. `breaks=1` will
produce a symmetrical scale without quantile capping.}

\item{gaps_at}{Columns of `colData` to use to establish gaps between columns.}

\item{gaps_row}{Passed to the heatmap function; if missing, will
be set automatically according to toporder.}

\item{left_annotation}{Columns of `rowData` to use for left annotation.
Alternatively, an `HeatmapAnnotation` object.}

\item{right_annotation}{Columns of `rowData` to use for left annotation.
Alternatively, an `HeatmapAnnotation` object.}

\item{top_annotation}{Columns of `colData` to use for top annotation.
Alternatively, an `HeatmapAnnotation` object. To disable (overriding
  defaults), use `top_annotation=character()`.}

\item{bottom_annotation}{Columns of `colData` to use for bottom annotation.
Alternatively, an `HeatmapAnnotation` object.}

\item{anno_colors}{List of colors to use for annotation.}

\item{show_rownames}{Whether to show row names (default TRUE if less than
50 rows to plot).}

\item{show_colnames}{Whether to show column names (default FALSE).}

\item{isMult}{Logical; used to silence labels when plotting multiple heatmaps}

\item{show_heatmap_legend}{Logical; whether to show heatmap legend}

\item{show_annotation_legend}{Logical; whether to show the annotation legend.}

\item{mark}{An optional vector of gene names to highlight.}

\item{na_col}{Color of NA values}

\item{annorow_title_side}{Side (top or bottom) of row annotation names}

\item{annocol_title_side}{Side (left or right) of column annotation names}

\item{includeMissing}{Logical; whether to include missing features (default
FALSE)}

\item{sort.method}{Row sorting method (see \code{\link{sortRows}})}

\item{...}{Further arguments passed to `Heatmap`}
}
\value{
A a \code{\link[ComplexHeatmap]{Heatmap-class}}.
}
\description{
ComplexHeatmap wrapper for
\code{\link[SummarizedExperiment]{SummarizedExperiment-class}}.
}
\examples{
data("Chen2017", package="sechm")
sechm(Chen2017, row.names(Chen2017)[1:10], do.scale=TRUE)

}
