% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{getDEGs}
\alias{getDEGs}
\title{Get DEGs from a SE or list of DEA results}
\usage{
getDEGs(
  x,
  dea = NULL,
  lfc.th = log2(1.3),
  fdr.th = 0.05,
  direction = 0,
  merge = TRUE
)
}
\arguments{
\item{x}{A `SummarizedExperiment` object with DEA results in rowData, or a
list of DEA result data.frames.}

\item{dea}{Which DEA(s) to use (default all). Used only if `x` is a
`SummarizedExperiment`.}

\item{lfc.th}{Absolute log-foldchange threshold.}

\item{fdr.th}{FDR threshold.}

\item{direction}{If !=0, specifies whether to fetch only upregulated or
downregulated features}

\item{merge}{Logical; whether to take the union of DEGs from the different
DEAs (when more than one).}
}
\value{
A character vector with the significant features, or a list of such
  vectors.
}
\description{
Get DEGs from a SE or list of DEA results
}
\examples{
# loading example SE
data("Chen2017", package="sechm")
# this ones doesn't have saved DEAs in the standard format:
getDEGs(Chen2017)
}
