% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_xfplate.R
\name{sketch_plate}
\alias{sketch_plate}
\title{Make an overview of plate layout, with colored groups}
\usage{
sketch_plate(xfplate, reorder_legend = FALSE)
}
\arguments{
\item{xfplate}{This the `raw_data` or the `rate_data` tibble
that is generated by the `revive_xfplate()` function}

\item{reorder_legend}{either `TRUE` or `FALSE`. When `TRUE` the
groups are ordered based on the number in the character string of
the group. It also adds a "__00" after each character string
to make the forcats::refactor(group, parse_number(group)) work.}
}
\value{
a ggplot object of a 96 well plate with the group
layout
}
\description{
A heatmap style ggplot figure with each well
labeled with a color for each group
}
\examples{
system.file("extdata",
    "20191219_SciRep_PBMCs_donor_A.xlsx",
    package = "seahtrue"
) |>
    revive_xfplate() |>
    purrr::pluck("raw_data", 1) |>
    sketch_plate(reorder_legend = TRUE)
}
