% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_xfplate.R
\name{sketch_assimilate_raw}
\alias{sketch_assimilate_raw}
\title{Combine multiple revived xf plates into one plot for raw data}
\usage{
sketch_assimilate_raw(my_df, param = "O2_mmHg")
}
\arguments{
\item{my_df}{a tibble generated by glue_xfplates() with
for each row representing a single xf experiment}

\item{param}{either "O2_mmHg", "pH", "O2_em_corr" or
"pH_em_corr}
}
\value{
a ggplot object
}
\description{
In this plot the O2, pH, or its emission
value at the very first measurement point plotted for all
wells from all xfplates that are provided to the function.
}
\examples{
suppressMessages(
    c(
        system.file("extdata",
            "20191219_SciRep_PBMCs_donor_A.xlsx",
            package = "seahtrue"
        ),
        system.file("extdata",
            "20191219_SciRep_PBMCs_donor_A.xlsx",
            package = "seahtrue"
        )
    ) |>
        glue_xfplates(arg_is_folder = FALSE) |>
        sketch_assimilate_raw(param = "O2_mmHg")
)
}
