% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_xfplate.R
\name{sketch_assimilate_rate}
\alias{sketch_assimilate_rate}
\title{Combine multiple revived xf plates into one plot for
rate data}
\usage{
sketch_assimilate_rate(my_df, param = "OCR", my_measurements = c(3, 6, 7, 12))
}
\arguments{
\item{my_df}{a tibble generated by glue_xfplates() with
for each row representing a single xf experiment}

\item{param}{either "OCR" or "ECAR"}

\item{my_measurements}{the measurements that needs to be
in the plot. For example, c(3,6,7,12) for a typical
mito stress test.}
}
\value{
a ggplot object
}
\description{
In this plot the OCR or ECAR is plotted per
group for each plate in a faceted gpgplot
}
\examples{
suppressMessages(
    c(
        system.file("extdata",
            "20191219_SciRep_PBMCs_donor_A.xlsx",
            package = "seahtrue"
        ),
        system.file("extdata",
            "20191219_SciRep_PBMCs_donor_A.xlsx",
            package = "seahtrue"
        )
    ) |>
        glue_xfplates(arg_is_folder = FALSE) |>
        sketch_assimilate_rate(
            param = "OCR",
            my_measurements = c(3, 4, 9, 12)
        )
)
}
