% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/citeseqApp.R
\name{getSubclLM}
\alias{getSubclLM}
\title{get lmFit for heterogeneity across subclusters}
\usage{
getSubclLM(inlist, clname)
}
\arguments{
\item{inlist}{list of SingleCellExperiments (SCEs) formed by scran::quickSubCluster}

\item{clname}{character(1) name of cluster SCE to assess}
}
\value{
limma::lmFit output
}
\description{
get lmFit for heterogeneity across subclusters
}
\note{
It is assumed that 'logcounts' is an assay element,
and that 'subcluster' is a colData element of each SCE in inlist
}
\examples{
all.sce <- getCh12AllSce()
lm3 <- getSubclLM(all.sce, "3")
names(lm3)
}
