% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_citeseq.R
\name{cacheCiteseqHDPmodel}
\alias{cacheCiteseqHDPmodel}
\title{grab scvi-tools muon-oriented VAE instance built on 
the PBMC datasets following the tutorial}
\usage{
cacheCiteseqHDPmodel()
}
\value{
invisibly, the path to the .zip file holding the weights in pt format for the fitted VAE
}
\description{
grab scvi-tools muon-oriented VAE instance built on 
the PBMC datasets following the tutorial
}
\note{
VAE construction followed tutorial at
`https://docs.scvi-tools.org/en/stable/tutorials/notebooks/totalVI.html`.

We are using the scvi tutorial read early may 2025.  The
notebook uses "h5 format of single-cell multiomic data generated 
by Proteintech Genomics ...
The data is from human resting PBMCs 
stained with the MultiPro® Human Discovery 
Panel (HDP) followed by processing using 10x Genomics 
Flex chemistry with Feature Barcoding Technology."

It may be advantageous to set `options(timeout=3600)` or to allow an even greater
time for internet downloads, if working at a relatively slow network connection.
}
\examples{
zpath <- cacheCiteseqHDPmodel()
td <- tempdir()
utils::unzip(zpath, exdir = td)
vaedir <- paste0(td, "/vae3_pt")
dir(vaedir)
}
