% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoreMarkers.R
\name{reportGroupMarkerStatistics}
\alias{reportGroupMarkerStatistics}
\title{Report marker statistics for a single group}
\usage{
reportGroupMarkerStatistics(
  results,
  group,
  effect.sizes = NULL,
  summaries = NULL,
  include.mean = TRUE,
  include.detected = TRUE
)
}
\arguments{
\item{results}{Named list of marker statistics, typically generated by \code{\link{scoreMarkers}} with \code{all.pairwise=FALSE}.}

\item{group}{String or integer scalar specifying the group of interest.}

\item{effect.sizes}{Character vector specifying the effect sizes of interest.
If \code{NULL}, all effect sizes are reported in the returned data frame.}

\item{summaries}{Character vector specifying the summary statistics of interest.
If \code{NULL}, all summaries are reported in the returned data frame.}

\item{include.mean}{Logical scalar indicating whether the mean expression should be reported in the returned data frame.}

\item{include.detected}{Logical scalar indicating whether the proportion of detected cells should be reported in the returned data frame.}
}
\value{
Data frame where each row corresponds to a gene.
Each column contains the requested statistics for \code{group}.
Effect size summary columns are named as \code{<EFFECT>.<SUMMARY>}.
}
\description{
Combine all marker statistics for a single group into a data frame for easy inspection.
Users can pick one of the columns for sorting potential marker genes.
}
\seealso{
\code{\link{scoreMarkers}}, to generate \code{results}.

\code{\link{summarizeEffects}}, for the trade-offs between effect size summaries.
}
\author{
Aaron Lun
}
