% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.R
\name{convertAnalyzeResults}
\alias{convertAnalyzeResults}
\title{Convert analysis results into a SingleCellExperiment}
\usage{
convertAnalyzeResults(
  results,
  main.modality = NULL,
  flatten.qc.subsets = TRUE,
  include.per.block.variances = FALSE
)
}
\arguments{
\item{results}{List of results produced by \code{\link{analyze}}.}

\item{main.modality}{String specifying the modality to use as the main experiment of a \link[SingleCellExperiment]{SingleCellExperiment}.}

\item{flatten.qc.subsets}{Logical scalar indicating whether QC metrics for subsets should be flattened in the column data.
If \code{FALSE}, subset metrics are reported as a nested \link[S4Vectors]{DataFrame}.}

\item{include.per.block.variances}{Logical scalar indicating whether the per-block variances should be reported as a nested \link[S4Vectors]{DataFrame} in the row data.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} containing most of the analysis results.
Filtered and normalized matrices are stored in the assays.
QC metrics, size factors and clusterings are stored in the column data.
Gene variances are stored in the row data.
PCA, t-SNE and UMAP results are stored in the reduced dimensions.
Further modalities are stored as alternative experiments.
}
\description{
Convert results from \code{\link{analyze}} into a \link[SingleCellExperiment]{SingleCellExperiment} for further analysis with Bioconductor packages.
}
\seealso{
\code{\link{analyze}}, to generate \code{results}.
}
\author{
Aaron Lun
}
