% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mqScpData}
\alias{mqScpData}
\title{Example MaxQuant/SCoPE2 output}
\format{
An object of class \code{data.frame} with 1361 rows and 149 columns.
}
\usage{
data("mqScpData")
}
\description{
A \code{data.frame} with 1088 observations and 139 variables, as
produced by reading a MaxQuant output file with
\code{\link[=read.delim]{read.delim()}}.
\itemize{
\item Sequence: a character vector
\item Length: a numeric vector
\item Modifications: a character vector
\item Modified.sequence: a character vector
\item Deamidation..N..Probabilities: a character vector
\item Oxidation..M..Probabilities: a character vector
\item Deamidation..N..Score.Diffs: a character vector
\item Oxidation..M..Score.Diffs: a character vector
\item Acetyl..Protein.N.term.: a numeric vector
\item Deamidation..N.: a numeric vector
\item Oxidation..M.: a numeric vector
\item Missed.cleavages: a numeric vector
\item Proteins: a character vector
\item Leading.proteins: a character vector
\item protein: a character vector
\item Gene.names: a character vector
\item Protein.names: a character vector
\item Type: a character vector
\item Set: a character vector
\item MS.MS.m.z: a numeric vector
\item Charge: a numeric vector
\item m.z: a numeric vector
\item Mass: a numeric vector
\item Resolution: a numeric vector
\item Uncalibrated...Calibrated.m.z..ppm.: a numeric vector
\item Uncalibrated...Calibrated.m.z..Da.: a numeric vector
\item Mass.error..ppm.: a numeric vector
\item Mass.error..Da.: a numeric vector
\item Uncalibrated.mass.error..ppm.: a numeric vector
\item Uncalibrated.mass.error..Da.: a numeric vector
\item Max.intensity.m.z.0: a numeric vector
\item Retention.time: a numeric vector
\item Retention.length: a numeric vector
\item Calibrated.retention.time: a numeric vector
\item Calibrated.retention.time.start: a numeric vector
\item Calibrated.retention.time.finish: a numeric vector
\item Retention.time.calibration: a numeric vector
\item Match.time.difference: a logical vector
\item Match.m.z.difference: a logical vector
\item Match.q.value: a logical vector
\item Match.score: a logical vector
\item Number.of.data.points: a numeric vector
\item Number.of.scans: a numeric vector
\item Number.of.isotopic.peaks: a numeric vector
\item PIF: a numeric vector
\item Fraction.of.total.spectrum: a numeric vector
\item Base.peak.fraction: a numeric vector
\item PEP: a numeric vector
\item MS.MS.count: a numeric vector
\item MS.MS.scan.number: a numeric vector
\item Score: a numeric vector
\item Delta.score: a numeric vector
\item Combinatorics: a numeric vector
\item Intensity: a numeric vector
\item Reporter.intensity.corrected.0: a numeric vector
\item Reporter.intensity.corrected.1: a numeric vector
\item Reporter.intensity.corrected.2: a numeric vector
\item Reporter.intensity.corrected.3: a numeric vector
\item Reporter.intensity.corrected.4: a numeric vector
\item Reporter.intensity.corrected.5: a numeric vector
\item Reporter.intensity.corrected.6: a numeric vector
\item Reporter.intensity.corrected.7: a numeric vector
\item Reporter.intensity.corrected.8: a numeric vector
\item Reporter.intensity.corrected.9: a numeric vector
\item Reporter.intensity.corrected.10: a numeric vector
\item RI1: a numeric vector
\item RI2: a numeric vector
\item RI3: a numeric vector
\item RI4: a numeric vector
\item RI5: a numeric vector
\item RI6: a numeric vector
\item RI7: a numeric vector
\item RI8: a numeric vector
\item RI9: a numeric vector
\item RI10: a numeric vector
\item RI11: a numeric vector
\item Reporter.intensity.count.0: a numeric vector
\item Reporter.intensity.count.1: a numeric vector
\item Reporter.intensity.count.2: a numeric vector
\item Reporter.intensity.count.3: a numeric vector
\item Reporter.intensity.count.4: a numeric vector
\item Reporter.intensity.count.5: a numeric vector
\item Reporter.intensity.count.6: a numeric vector
\item Reporter.intensity.count.7: a numeric vector
\item Reporter.intensity.count.8: a numeric vector
\item Reporter.intensity.count.9: a numeric vector
\item Reporter.intensity.count.10: a numeric vector
\item Reporter.PIF: a logical vector
\item Reporter.fraction: a logical vector
\item Reverse: a character vector
\item Potential.contaminant: a logical vector
\item id: a numeric vector
\item Protein.group.IDs: a character vector
\item Peptide.ID: a numeric vector
\item Mod..peptide.ID: a numeric vector
\item MS.MS.IDs: a character vector
\item Best.MS.MS: a numeric vector
\item AIF.MS.MS.IDs: a logical vector
\item Deamidation..N..site.IDs: a numeric vector
\item Oxidation..M..site.IDs: a logical vector
\item remove: a logical vector
\item dart_PEP: a numeric vector
\item dart_qval: a numeric vector
\item razor_protein_fdr: a numeric vector
\item Deamidation..NQ..Probabilities: a logical vector
\item Deamidation..NQ..Score.Diffs: a logical vector
\item Deamidation..NQ.: a logical vector
\item Reporter.intensity.corrected.11: a logical vector
\item Reporter.intensity.corrected.12: a logical vector
\item Reporter.intensity.corrected.13: a logical vector
\item Reporter.intensity.corrected.14: a logical vector
\item Reporter.intensity.corrected.15: a logical vector
\item Reporter.intensity.corrected.16: a logical vector
\item RI12: a logical vector
\item RI13: a logical vector
\item RI14: a logical vector
\item RI15: a logical vector
\item RI16: a logical vector
\item Reporter.intensity.count.11: a logical vector
\item Reporter.intensity.count.12: a logical vector
\item Reporter.intensity.count.13: a logical vector
\item Reporter.intensity.count.14: a logical vector
\item Reporter.intensity.count.15: a logical vector
\item Reporter.intensity.count.16: a logical vector
\item Deamidation..NQ..site.IDs: a logical vector
\item input_id: a logical vector
\item rt_minus: a logical vector
\item rt_plus: a logical vector
\item mu: a logical vector
\item muij: a logical vector
\item sigmaij: a logical vector
\item pep_new: a logical vector
\item exp_id: a logical vector
\item peptide_id: a logical vector
\item stan_peptide_id: a logical vector
\item exclude: a logical vector
\item residual: a logical vector
\item participated: a logical vector
\item peptide: a character vector
}
}
\details{
The dataset is a subset of the SCoPE2 dataset (version 2, Specht
et al. 2019,
\href{https://www.biorxiv.org/content/10.1101/665307v3}{BioRXiv}). The
input file \code{evidence_unfiltered.csv} was downloaded from a
\href{https://drive.google.com/drive/folders/1VzBfmNxziRYqayx3SP-cOe2gu129Obgx}{Google Drive repository}.
The MaxQuant evidence file was loaded and the data was cleaned
(renaming columns, removing duplicate fields,...).  MS runs that
were selected in the \code{scp1} dataset (see \code{?scp1}) were kept along
with a blank run. The data is stored as a \code{data.frame}.
}
\seealso{
\code{\link[=readSCP]{readSCP()}} for an example on how \code{mqScpData} is
parsed into a \link{QFeatures} object.
}
\keyword{datasets}
