% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{divideByReference}
\alias{divideByReference}
\title{Divide assay columns by a reference column}
\usage{
divideByReference(object, i, colvar, samplePattern = ".", refPattern)
}
\arguments{
\item{object}{A \code{QFeatures} object}

\item{i}{A \code{numeric()} or \code{character()} vector indicating from which
assays the \code{rowData} should be taken.}

\item{colvar}{A \code{character(1)} indicating the variable to take from
\code{colData(object)} that gives the sample annotation.}

\item{samplePattern}{A \code{character(1)} pattern that matches the sample
encoding in \code{colvar}. By default all samples are devided (using the
regex wildcard \code{.}).}

\item{refPattern}{A \code{character(1)} pattern that matches the carrier
encoding in \code{colvar}. Only one match per assay is allowed, otherwise
only the first match is taken}
}
\value{
A \code{QFeatures} object
}
\description{
The function divides the sample columns by a reference column. The sample
and reference columns are defined based on the provided \code{colvar}
variable and on regular expression matching.
}
\details{
The supplied assay(s) are replaced with the values computed after reference
division.
}
\examples{
data("scp1")
scp1 <- divideByReference(scp1, 
                          i = 1, 
                          colvar = "SampleType",
                          samplePattern = "Macrophage",
                          refPattern = "Ref")
                          
}
