% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregateFeaturesOverAssays-deprecated.R
\name{aggregateFeaturesOverAssays-deprecated}
\alias{aggregateFeaturesOverAssays-deprecated}
\alias{aggregateFeaturesOverAssays}
\title{Aggregate features over multiple assays}
\usage{
aggregateFeaturesOverAssays(object, i, fcol, name, fun, ...)
}
\arguments{
\item{object}{A \code{QFeatures} object}

\item{i}{A \code{numeric(1)} or \code{character(1)} indicating which assay
to transfer the \code{colData} to.}

\item{fcol}{The feature variables for each assays \code{i} defining how
to summarise the QFeatures. If \code{fcol} has length 1, the
variable name is assumed to be the same for all assays}

\item{name}{A \code{character()} naming the new assay. \code{name} must have
the same length as \code{i}. Note that the function will fail if of
the names in \code{name} is already present.}

\item{fun}{A function used for quantitative feature aggregation.}

\item{...}{Additional parameters passed the \code{fun}.}
}
\value{
A \code{QFeatures} object
}
\description{
The \code{aggregateFeaturesOverAssays} function is deprecated and will be
removed in a future release. Please use the \code{aggregateFeatures} method
from the \code{QFeatures} package instead.

This function is a wrapper function around
\link[QFeatures:QFeatures-aggregate]{QFeatures::aggregateFeatures}.
It allows the user to provide multiple assays for which
\code{aggregateFeatures} will be applied sequentially.
}
\examples{
data("scp1")
scp1 <- aggregateFeaturesOverAssays(scp1,
                                    i = 1:3,
                                    fcol = "peptide",
                                    name = paste0("peptides", 1:3),
                                    fun = colMeans,
                                    na.rm = TRUE)
scp1

}
\seealso{
\link[QFeatures:QFeatures-aggregate]{QFeatures::aggregateFeatures}
}
