% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScpModelFit-Class.R
\docType{class}
\name{ScpModelFit}
\alias{ScpModelFit}
\alias{ScpModelFit-class}
\alias{class:ScpModelFit}
\title{Class to store the components of an estimated model for a
feature}
\description{
An \code{ScpModelFit} object is expected to be stored as a list element
in the \code{scpModelFitList} of an \code{ScpModel} object. The
\code{ScpModelFit} object should \strong{never be accessed directly} by the
user. Refer to the \linkS4class{ScpModel} for a list of function to
access the information in an \code{ScpModelFit}. The \code{ScpModelFit}
class contains several slots that contain the model output for a
feature:
\itemize{
\item \code{n}: an \code{integer}, the number of observations for the feature
\item \code{p}: an \code{integer}, the number of coefficient to estimate
\item \code{coefficients}: a \code{numeric} vector with the estimated
coefficients
\item \code{residuals}: a \code{numeric} vector with the estimated residuals
\item \code{effects}: a \code{List} with the
\item \code{df}: an \code{integer} providing the number of degrees of freedom
of the model estimation
\item \code{var}: a \code{numeric} vector with the residual variance of the
model estimation
\item \code{uvcov}: the unscaled variance covariance \code{matrix}
\item \code{levels}: a named \code{List} where each elements corresponds to a
categorical model variable and contains a vector with the
possible categories.
}
}
\examples{
new("ScpModelFit") ## this should never be used by the user

}
\seealso{
\linkS4class{ScpModel} for a description of the class that relies on
\code{ScpModelFit}
}
\author{
Christophe Vanderaa, Laurent Gatto
}
