% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkSNPs.R
\name{checkSNPs}
\alias{checkSNPs}
\title{Check genotype object}
\usage{
checkSNPs(SNPobj, checkAlleleFreqs = TRUE)
}
\arguments{
\item{SNPobj}{List with SNPs data from plink or \code{VCF-class}.}

\item{checkAlleleFreqs}{Should allele frequencies be check (Default: TRUE)}
}
\value{
List containing the SNPs prepared for \code{scoreInvHap}
\itemize{
\item{genos: Object with genotype data ready for scoreInvHap}
\item{wrongAlleles: Character vector with the SNPs discarded due to having alleles different to reference}
\item{wrongFreqs: Character vector with the SNPs discarded due to having allele frequencies different to reference}
}
}
\description{
This function checks the genotype object before passing the SNPs to `scoreInvHap`. The
function removes SNPs with different alleles or different allele frequencies. Nonetheless,
it is possible that these SNPs could be recovered after an examination of the results. Be
aware that testing of allele frequencies might fail for small datasets.
}
\examples{

## Run method
if(require(VariantAnnotation)){
    vcf <- readVcf(system.file("extdata", "example.vcf", package = "scoreInvHap"), "hg19")
    resList <- checkSNPs(vcf)
    resList
}
}
