% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/pareto_norm.R
\name{PsiNorm}
\alias{PsiNorm}
\alias{PsiNorm,SummarizedExperiment-method}
\alias{PsiNorm,SingleCellExperiment-method}
\alias{PsiNorm,ANY-method}
\title{PsiNorm: scaling normalization based on the Pareto distribution}
\usage{
PsiNorm(x, ...)

\S4method{PsiNorm}{SummarizedExperiment}(x, whichAssay = 1, assayName = "PsiNorm")

\S4method{PsiNorm}{SingleCellExperiment}(x, whichAssay = "counts")

\S4method{PsiNorm}{ANY}(x)
}
\arguments{
\item{x}{A SingleCellExperiment/SummarizedExperiment object or a
matrix=like object with genes in rows and samples in columns.}

\item{...}{generic argument}

\item{whichAssay}{if x is a SingleCellExperiment/SummarizedExperiment the
assay with the counts to normalize (default to 1).}

\item{assayName}{if x is a SummarizedExperiment the name of the assay in
which to save the normalized data (default to "PsiNorm").}
}
\value{
If the input is a SingleCellExperiment object the function returns
  the same object adding as sizeFactors those computed by PsiNorm. If the
  object is a SummarizedExperiment object, the function returns the same
  object adding an assay with the normalized count matrix. If the input
  is a matrix-like object PsiNorm returns a matrix with the
  same dimensions containing the normalized counts.
}
\description{
Normalization of a raw counts matrix using the estimate of the shape
parameter of the Pareto distribution.
}
\examples{
m<-matrix(c(1,0,2,0,2,9,3,0), ncol=2)
sce<-SingleCellExperiment::SingleCellExperiment(assays=list(counts=m))

sce<-PsiNorm(sce) # SingleCellExperiment object
norm.matrix<-PsiNorm(m) # normalized matrix object

}
\author{
Matteo Borella and Davide Risso
}
