% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{report}
\alias{report}
\title{Generates an inclusive report on methylation analysis}
\usage{
report(bsObj, outdirectory, organism, genome, mbiasDir = NULL,
  subSample = 1e+06, offset = 50000, small = FALSE)
}
\arguments{
\item{bsObj}{bsseq object}

\item{outdirectory}{name of the output directory where the
report will be saved}

\item{organism}{scientific name of the organism of interest,
e.g. Mmusculus or Hsapiens}

\item{genome}{reference alignment, e.g. mm10 or hg38
the report will have graphics on read information}

\item{mbiasDir}{Optional argument to provide directory name
that has the mbias files or the list of mbias files}

\item{subSample}{number of CpGs to subsample
Default value is 1000000.}

\item{offset}{how many CpGs to offset when subsampling
Default value is set to be 50000, i.e. first 50000 CpGs will
be ignored in subsampling.}

\item{small}{Indicator for a small dataset, cpg density is calculated more}
}
\value{
Report will be an html file
}
\description{
This function uses most of the functions in this package to
generate a report for the user
}
\examples{
library(BSgenome.Hsapiens.NCBI.GRCh38)
directory <- system.file("extdata/bismark_data", package='scmeth')
bs <- HDF5Array::loadHDF5SummarizedExperiment(directory)
mbiasDirectory=system.file("extdata", package='scmeth')
outDir <- system.file(package='scmeth')
report(bs, outDir, Hsapiens, 'hg38', mbiasDir=mbiasDirectory, small=TRUE)
}
