% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage.R
\name{coverage}
\alias{coverage}
\title{Coverage for single cells}
\usage{
coverage(bs, subSample = 1e+06, offset = 50000)
}
\arguments{
\item{bs}{bsseq object}

\item{subSample}{number of CpGs to subsample.
Default value is 1000000.}

\item{offset}{how many CpGs to offset when subsampling
Default value is set to be 50000, i.e. first 50000 CpGs will
be ignored in subsampling.}
}
\value{
vector of coverage for the cells in bs object
}
\description{
Provides Coverage for each cell in a library pool
}
\examples{
directory <- system.file("extdata/bismark_data", package='scmeth')
bs <- HDF5Array::loadHDF5SummarizedExperiment(directory)
coverage(bs)
}
