% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/CoreMethods.R
\docType{methods}
\name{setFeatures}
\alias{setFeatures}
\alias{setFeatures}
\alias{setFeatures.SingleCellExperiment}
\alias{setFeatures,SingleCellExperiment-method}
\alias{setFeatures}
\title{Set the most important features (genes/transcripts) for projection}
\usage{
setFeatures(object, features = NULL)

setFeatures.SingleCellExperiment(object, features)

\S4method{setFeatures}{SingleCellExperiment}(object, features = NULL)
}
\arguments{
\item{object}{an object of \code{\link[SingleCellExperiment]{SingleCellExperiment}} class}

\item{features}{a character vector of feature names}
}
\value{
an object of \code{\link[SingleCellExperiment]{SingleCellExperiment}} class with a new column in 
\code{rowData(object)} slot which is called \code{scmap_features}. It can be accessed
by using \code{as.data.frame(rowData(object))$scmap_features}.
}
\description{
This method manually sets the features to be used for projection.
}
\details{
Please note that \code{feature_symbol} column of \code{rowData(object)} must be 
present in the input object and should not contain any duplicated feature names. 
This column defines feature names used during projection. Feature symbols 
in the reference dataset must correpond to the feature symbols
in the projection dataset, otherwise the mapping will not work!
}
\examples{
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(normcounts = as.matrix(yan)), colData = ann)
# this is needed to calculate dropout rate for feature selection
# important: normcounts have the same zeros as raw counts (fpkm)
counts(sce) <- normcounts(sce)
logcounts(sce) <- log2(normcounts(sce) + 1)
# use gene names as feature symbols
rowData(sce)$feature_symbol <- rownames(sce)
# remove features with duplicated names
sce <- sce[!duplicated(rownames(sce)), ]
sce <- setFeatures(sce, c('MMP2', 'ZHX3'))

}
