% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/CoreMethods.R
\docType{methods}
\name{scmapCell}
\alias{scmapCell}
\alias{scmapCell}
\alias{scmapCell.SingleCellExperiment}
\alias{scmapCell,SingleCellExperiment-method}
\alias{scmapCell}
\title{For each cell in a query dataset, we search for the nearest neighbours by cosine distance
within a collection of reference datasets.}
\usage{
scmapCell(projection = NULL, index_list = NULL, w = 10)

scmapCell.SingleCellExperiment(projection, index_list, w)

\S4method{scmapCell}{SingleCellExperiment}(projection = NULL,
  index_list = NULL, w = 10)
}
\arguments{
\item{projection}{an object of \code{\link[SingleCellExperiment]{SingleCellExperiment}} class}

\item{index_list}{list of index objects each coming from the output of `indexCell`}

\item{w}{a positive integer specifying the number of nearest neighbours to find}
}
\value{
a list of 3 objects: 
1) a matrix with the closest w neighbours by cell number of each query cell stored by column
2) a matrix of integers giving the reference datasets from which the above cells came from
3) a matrix with the cosine similarities corresponding to each of the nearest neighbours
}
\description{
For each cell in a query dataset, we search for the nearest neighbours by cosine distance
within a collection of reference datasets.
}
\examples{
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(normcounts = as.matrix(yan)), colData = ann)
# this is needed to calculate dropout rate for feature selection
# important: normcounts have the same zeros as raw counts (fpkm)
counts(sce) <- normcounts(sce)
logcounts(sce) <- log2(normcounts(sce) + 1)
# use gene names as feature symbols
rowData(sce)$feature_symbol <- rownames(sce)
# remove features with duplicated names
sce <- sce[!duplicated(rownames(sce)), ]
sce <- selectFeatures(sce)
sce <- indexCell(sce)
scmapCell_results <- scmapCell(sce, list(metadata(sce)$scmap_cell_index))

}
