# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Computes the dot product between the subcentroids from the indexed reference and the subvectors of an element of the query dataset. 
#' Returns an M by k matrix. Used as an intermediate step (in NNfirst and NNmult) for calculating
#' an approximation of the cosine similarity between the query and the reference. 
#' 
#' @param subcentroids A list of matrices containing the subcentroids of each chunk.
#' @param query_chunks A list of matrices containing the chunks of the query dataset after it has been split
#' according to the product quantization method
#' @param M An integer specifying the number of chunks
#' @param k An integer specifying the number of subcentroids per chunk
#' @param cellnum An integer specifying the column of the query dataset we wish to consider
subdistsmult <- function(subcentroids, query_chunks, M, k, cellnum) {
    .Call('_scmap_subdistsmult', PACKAGE = 'scmap', subcentroids, query_chunks, M, k, cellnum)
}

#' Normalises each column of a matrix
#' 
#' @param dat A numerical matrix
normalise <- function(dat) {
    .Call('_scmap_normalise', PACKAGE = 'scmap', dat)
}

#' Main nearest neighbour calculation function. Used on the first reference dataset.
#' Returns a list of three objects:
#' 1) the cell indices of the w nearest neighbours
#' 2) the corresponding approx. cosine similarities
#' 
#' @param w An integer specifying the number of nearest neighbours
#' @param k An integer specifying the number of subcentroids for each product quantization chunk
#' @param subcentroids A list of matrices containing the subcentroids of each chunk.
#' @param subclusters A matrix containing the subcentroid assignments of each reference cell. See scf_index.
#' @param query_chunks A list of matrices containing the chunks of the query dataset after it has been split
#' according to the product quantization method
#' @param M An integer specifying the number of chunks
#' @param SqNorm A numerical vector containing the Euclidean Squared Norm of each query cell.
NN <- function(w, k, subcentroids, subclusters, query_chunks, M, SqNorm) {
    .Call('_scmap_NN', PACKAGE = 'scmap', w, k, subcentroids, subclusters, query_chunks, M, SqNorm)
}

#' The Euclidean Squared Norm of each column of a matrix is computed and the whole result is returned as a vector.
#' Used as part of the approx. calculations of the cosine similarity between the query and the reference.
#' 
#' @param dat A numerical matrix
EuclSqNorm <- function(dat) {
    .Call('_scmap_EuclSqNorm', PACKAGE = 'scmap', dat)
}

