% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcs_processing.R
\name{fcs_processing}
\alias{fcs_processing}
\title{Extract index sorting from flow cytometry data}
\usage{
fcs_processing(
  folder_path = "test/test_dataset/fcs_files/",
  compensation = TRUE,
  plate_wells = 96,
  probe1 = "Pre.F",
  probe2 = "Post.F",
  posvalue_probe1 = 600,
  posvalue_probe2 = 400
)
}
\arguments{
\item{folder_path}{Folder containing all the flow data index filex (.fcs). Files should be named with their sample/plate ID.   eg. "E11_01.fcs"}

\item{compensation}{Logical argument, TRUE or FALSE, to indicate if the index files were compensated or not. If TRUE, it will apply its compensation prior assigning specificity}

\item{plate_wells}{Type of plate used for single-cell sorting. eg. "96" or "384"}

\item{probe1}{Name of the first channel used for the probe or the custom name assigned to the channel in the index file. eg. "FSC.A", "FSC.H", "SSC.A","DsRed.A", "PE.Cy5_5.A", "PE.Cy7.A","BV650.A", "BV711.A","Alexa.Fluor.700.A" "APC.Cy7.A","PerCP.Cy5.5.A","Time"}

\item{probe2}{Name of the second channel used for the probe or the custom name assigned to the channel in the index file. eg. "FSC.A", "FSC.H", "SSC.A","DsRed.A", "PE.Cy5_5.A", "PE.Cy7.A","BV650.A", "BV711.A","Alexa.Fluor.700.A" "APC.Cy7.A","PerCP.Cy5.5.A","Time"}

\item{posvalue_probe1}{Threshold used for fluorescence intensities to be considered as positive for the first probe}

\item{posvalue_probe2}{Threshold used for fluorescence intensities to be considered as positive for the second probe}
}
\value{
If saved as an object, it returns a table containing all the processed flow cytometry index files, with their fluorescence intensities for each channel and well position.
}
\description{
Extracts the Mean Fluoresnce Intensity (MFI) values from the flow cytometry 
index files (.fcs) and assign specificity to each single-cell sorted well 
according to the fluorescence intensity of the probes.
}
\examples{
index_sort_data <- fcs_processing(
    folder_path = system.file("/extdata/fcs_index_sorting",
        package = "scifer"
    ),
    compensation = TRUE, plate_wells = 96,
    probe1 = "Pre.F", probe2 = "Post.F",
    posvalue_probe1 = 600, posvalue_probe2 = 400
)

}
