% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGrid.R
\name{plotGrid}
\alias{plotGrid}
\title{Plot grid from metadata.}
\usage{
plotGrid(
  spe,
  group.by = NULL,
  feature = NULL,
  assay = "counts",
  type = c("raw", "log", "cpm", "logcpm"),
  cols = NULL,
  pol.border = FALSE,
  pol.alpha = 1,
  probs = 0,
  cutoff = NULL,
  label = NULL,
  cols.scale = NULL,
  reverseY = NULL,
  ...
)
}
\arguments{
\item{spe}{A SpatialExperiment object.}

\item{group.by}{values to group polygons by. Must be in
spe@metadata$grid_density, or colData(spe) if gridLevelAnalysis is TRUE.
If NULL, will try with cols if available.}

\item{feature}{Feature to group polygons by. Must be in rownames(spe).}

\item{assay}{Name of assay to use for plotting feature.}

\item{type}{Transformation to apply for the group/feature. Options are "raw"
, "log", "cpm", "logcpm", or a function that accepts and returns a vector of
the same length.}

\item{cols}{Colour palette. Can be a vector of colours or a function
that accepts an integer n and return n colours.}

\item{pol.border}{Boolean. Whether to draw border for each polygon.}

\item{pol.alpha}{alpha of points between 0 and 1.}

\item{probs}{Numeric value between 0 and 1, used for filtering
uninformative grid. Only applicable for continuous values.}

\item{cutoff}{Numeric. Either a vector of length 2 for the lower & upper
bounds of data to be included, or length 1 for the lower bound. Override
probs if specified. Only applicable for continuous values.}

\item{label}{label for the legend}

\item{cols.scale}{vector of position for color if colors should not be
evenly positioned. See \link[ggplot2]{scale_fill_gradientn}. Only applicable for continuous values.}

\item{reverseY}{Logical. Whether to reverse Y coordinates. Default is TRUE
if the spe contains an image (even if not plotted) and FALSE if otherwise.}

\item{...}{Parameters pass to \link[scider]{plotImage}}
}
\value{
A ggplot object.
}
\description{
Plot grid from metadata.
}
\examples{

data("xenium_bc_spe")

spe <- gridDensity(spe)

plotGrid(spe, group.by = "density_overall")

}
