% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moran.R
\name{localMoran}
\alias{localMoran}
\title{Calculate local Moran for 1 to 2 variables.}
\usage{
localMoran(
  spe,
  data1,
  data2 = data1[],
  at = c("grid", "cell"),
  nbrs_name = NULL,
  hhonly = FALSE,
  significance_cutoff = 0.05,
  permutations = 999,
  seed = 123456789,
  cpu_threads = 6
)
}
\arguments{
\item{spe}{A SpatialExperiment object.}

\item{data1}{Numeric vector 1. Must be same length as number of grid points
or cells, depending on 'at'.}

\item{data2}{Numeric vector 2 for bivariate local Moran. Must be same length as data1.}

\item{at}{Option of grid or cell for where to look for neighbour list}

\item{nbrs_name}{Name of the neighbour list in \code{spe@metadata$grid[[at]]}
for Moran's I. If NULL, will use the newest neighbour list.}

\item{hhonly}{Only high-high clusters, which is more interpretable. Other
clusters (e.g. "Low-Low","High-Low",...) will be assigned as undefined.}

\item{significance_cutoff}{Cutoff for p-value to filter non-significant clusters}

\item{permutations}{Number of permutations for p-value.}

\item{seed}{Integer. For random permutations.}

\item{cpu_threads}{The number of cpu threads used for parallel computation.}
}
\value{
List of lisa_value, clusters, and pseudo p-value.
}
\description{
Calculate local Moran for 1 to 2 variables.
}
\examples{
data("xenium_bc_spe")

## At grid.
spe <- gridDensity(spe, coi = "Breast cancer")
dat <- spe@metadata$grid_density$density_breast_cancer
spe <- findNbrsGrid(spe)
res <- localMoran(spe,data1=dat, at = "grid")

## At cell.
dat <- as.numeric(spe$cell_type=="Breast cancer")
spe <- findNbrsSpatial(spe,k=20)
res <- localMoran(spe,data1=dat,at="cell")
}
