% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findROI.R
\name{findROI}
\alias{findROI}
\title{Find ROIs based on cell type-specific densities via graph-based method.}
\usage{
findROI(
  spe,
  coi = NULL,
  probs = 0.85,
  min.density = NULL,
  ngrid.min = 20,
  method = c("greedy", "walktrap", "connected", "hdbscan", "eigen", "dbscan"),
  diag.nodes = FALSE,
  sequential.roi.name = TRUE,
  zoom.in = FALSE,
  zoom.in.size = 500L,
  ...
)
}
\arguments{
\item{spe}{A SpatialExperiment object.}

\item{coi}{A character vector of cell types of interest (COIs).
Default to all cell types.}

\item{probs}{A numeric scalar. The threshold of proportion that used to
filter grids by density. Default to 0.85.}

\item{min.density}{A numeric value. The cut-off value used to filter grids
by density. Default is NULL and overwrites probs.}

\item{ngrid.min}{An integer. The minimum number of grids required for
defining a ROI. Default to 20.}

\item{method}{The community dectection method to be used, possible options
are greedy, walktrap, connected, hdbscan, eigen or dbscan.
Default to greedy, can be abbreviated.}

\item{diag.nodes}{Logical. Set this to TRUE to allow diagonal grid points
to be adjacent nodes.}

\item{sequential.roi.name}{Logical. Set this to FALSE if you want the
original ROI name before
filtering are retained.}

\item{zoom.in}{Logical. For very large ROIs, whether to zoom in and try
to get more refined ROIs.}

\item{zoom.in.size}{A numeric scaler. Smallest size of an ROI to be able
to zoom in. Default is 500L.}

\item{...}{Other parameters that passed to walktrap.community when method =
"walktrap".}
}
\value{
A SpatialExperiment object.
}
\description{
Find ROIs based on cell type-specific densities via graph-based method.
}
\examples{

data("xenium_bc_spe")

coi <- c("Breast cancer", "Fibroblasts")

spe <- gridDensity(spe, coi = coi)

spe <- findROI(spe, coi = coi, method = "walktrap")

}
