% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findNbrsSpatial.R
\name{findNbrsSpatial}
\alias{findNbrsSpatial}
\title{Construct a distance-based neighbour list from cell coordinates.}
\usage{
findNbrsSpatial(
  spe,
  k = NULL,
  radius = NULL,
  dist_func = c("idw", "exp", "binary", "none"),
  standardisation = c("none", "row"),
  scale = 1,
  nbrs_name = NULL,
  cpu_threads = 6
)
}
\arguments{
\item{spe}{A SpatialExperiment object.}

\item{k}{Integer scalar for number of nearest neighbours to find. Can be used
with radius. See details.}

\item{radius}{Numeric for maximum distance to search for neighbours. Can be
with k. See details}

\item{dist_func}{Options for distance-based weight. "idw" for inverse
distance, "exp" for exponential decay, "binary" for constant weight, and
"none" for raw euclidean distance.}

\item{standardisation}{Options for weight standardisation. "none" for
nothing, and "row" for dividing weights by number of neighbours.}

\item{scale}{Numeric scaler for weight scaling.}

\item{nbrs_name}{Name of the neighbour list to be stored. Default to be "spatial".}

\item{cpu_threads}{Number of cpu threads for parallel computation.}
}
\value{
A SpatialExperiment object with neighbour list stored in
\code{spe@metadata$nbrs$cell[[nbrs_name]]}
}
\description{
Construct a distance-based neighbour list from cell coordinates.
}
\details{
if only \code{k} is provided, neighbours are found using
\link[BiocNeighbors]{findKNN}. If only \code{radius} is provided, neighbours are
found using \link[BiocNeighbors]{findNeighbors}. If both are provided, then
knn is done first then neighbours are filtered to only those within radius.
}
\examples{

data("xenium_bc_spe")
spe <- findNbrsSpatial(spe,k=20,radius=100)
}
