% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allocateCells.R
\name{allocateCells}
\alias{allocateCells}
\title{Annotate all cells with contour level of cell type-specific density.}
\usage{
allocateCells(
  spe,
  to.roi = TRUE,
  roi = NULL,
  to.contour = TRUE,
  contour = NULL
)
}
\arguments{
\item{spe}{A SpatialExperiment object.}

\item{to.roi}{Logical. Whether to allocate cells to ROIs.}

\item{roi}{Character. The name of the group or cell type on which
the roi is computed. If NULL, then the cell allocation will
be performed for all detected roi Default to NULL.}

\item{to.contour}{Logical. Whether to allocate cells to contour levels.}

\item{contour}{Character. The name of the group or cell type on which
the contour level is computed. If NULL, then the cell allocation will
be performed for all detected contours. Default to NULL.}
}
\value{
A SpatialExperiment object. An extra column is added to the colData.
}
\description{
Annotate all cells with contour level of cell type-specific density.
}
\examples{

data("xenium_bc_spe")
spe <- gridDensity(spe)
coi <- "Breast cancer"
spe <- findROI(spe, coi = coi)
spe <- getContour(spe, coi = coi)
spe <- allocateCells(spe, contour = coi)

}
