% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{show.app}
\alias{show.app}
\title{View PAGODA application}
\usage{
show.app(app, name, browse = TRUE, port = NULL, ip = "127.0.0.1",
  server = NULL)
}
\arguments{
\item{app}{pagoda app (output of make.pagoda.app()) or another rook app}

\item{name}{URL path name for this app}

\item{browse}{whether a call should be made for browser to show the app}

\item{port}{optional port on which the server should be initiated}

\item{ip}{IP on which the server should listen (typically localhost)}

\item{server}{an (optional) Rook server instance (defaults to ___scde.server)}
}
\value{
Rook server instance
}
\description{
Installs a given pagoda app (or any other rook app) into a server, optionally
making a call to show it in the browser.
}
\examples{
\donttest{
app <- make.pagoda.app(tamr2, tam, varinfo, go.env, pwpca, clpca, col.cols=col.cols, cell.clustering=hc, title="NPCs")
# show app in the browser (port 1468)
show.app(app, "pollen", browse = TRUE, port=1468)
}

}

