% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{scde.posteriors}
\alias{scde.posteriors}
\title{Calculate joint expression magnitude posteriors across a set of cells}
\usage{
scde.posteriors(models, counts, prior, n.randomizations = 100, batch = NULL,
  composition = NULL, return.individual.posteriors = FALSE,
  return.individual.posterior.modes = FALSE, ensemble.posterior = FALSE,
  n.cores = 20)
}
\arguments{
\item{models}{models models determined by \code{\link{scde.error.models}}}

\item{counts}{read count matrix}

\item{prior}{gene expression prior as determined by \code{\link{scde.expression.prior}}}

\item{n.randomizations}{number of bootstrap iterations to perform}

\item{batch}{a factor describing which batch group each cell (i.e. each row of \code{models} matrix) belongs to}

\item{composition}{a vector describing the batch composition of a group to be sampled}

\item{return.individual.posteriors}{whether expression posteriors of each cell should be returned}

\item{return.individual.posterior.modes}{whether modes of expression posteriors of each cell should be returned}

\item{ensemble.posterior}{Boolean of whether to calculate the ensemble posterior (sum of individual posteriors) instead of a joint (product) posterior. (default: FALSE)}

\item{n.cores}{number of cores to utilize}
}
\value{
\subsection{default}{ a posterior probability matrix, with rows corresponding to genes, and columns to expression levels (as defined by \code{prior$x})
}
\subsection{return.individual.posterior.modes}{ a list is returned, with the \code{$jp} slot giving the joint posterior matrix, as described above. The \code{$modes} slot gives a matrix of individual expression posterior mode values on log scale (rows - genes, columns -cells)}
\subsection{return.individual.posteriors}{ a list is returned, with the \code{$post} slot giving a list of individual posterior matrices, in a form analogous to the joint posterior matrix, but reported on log scale }
}
\description{
Calculates expression magnitude posteriors for the individual cells, and then uses bootstrap resampling to calculate a joint expression posterior for all the specified cells. Alternatively during batch-effect correction procedure, the joint posterior can be calculated for a random composition of cells of different groups (see \code{batch} and \code{composition} parameters).
}
\examples{
data(es.mef.small)
cd <- clean.counts(es.mef.small, min.lib.size=1000, min.reads = 1, min.detected = 1)
data(o.ifm)  # Load precomputed model. Use ?scde.error.models to see how o.ifm was generated
o.prior <- scde.expression.prior(models = o.ifm, counts = cd, length.out = 400, show.plot = FALSE)
# calculate joint posteriors
jp <- scde.posteriors(o.ifm, cd, o.prior, n.cores = 1)

}

