% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{pagoda.view.aspects}
\alias{pagoda.view.aspects}
\title{View PAGODA output}
\usage{
pagoda.view.aspects(tamr, row.clustering = hclust(dist(tamr$xv)), top = Inf,
  ...)
}
\arguments{
\item{tamr}{Combined pathways that show similar expression patterns. Output of \code{\link{pagoda.reduce.redundancy}}}

\item{row.clustering}{Dendrogram of combined pathways clustering}

\item{top}{Restrict output to the top n aspects of heterogeneity}

\item{...}{additional arguments are passed to the \code{\link{view.aspects}} method during plotting}
}
\value{
PAGODA heatmap
}
\description{
Create static image of PAGODA output visualizing cell hierarchy and top aspects of transcriptional heterogeneity
}
\examples{
data(pollen)
cd <- clean.counts(pollen)
\donttest{
knn <- knn.error.models(cd, k=ncol(cd)/4, n.cores=10, min.count.threshold=2, min.nonfailed=5, max.model.plots=10)
varinfo <- pagoda.varnorm(knn, counts = cd, trim = 3/ncol(cd), max.adj.var = 5, n.cores = 1, plot = FALSE)
pwpca <- pagoda.pathway.wPCA(varinfo, go.env, n.components=1, n.cores=10, n.internal.shuffles=50)
tam <- pagoda.top.aspects(pwpca, return.table = TRUE, plot=FALSE, z.score=1.96)  # top aspects based on GO only
pagoda.view.aspects(tam)
}

}

