% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{pagoda.show.pathways}
\alias{pagoda.show.pathways}
\title{View pathway or gene weighted PCA}
\usage{
pagoda.show.pathways(pathways, varinfo, goenv = NULL, n.genes = 20,
  two.sided = FALSE, n.pc = rep(1, length(pathways)), colcols = NULL,
  zlim = NULL, showRowLabels = FALSE, cexCol = 1, cexRow = 1,
  nstarts = 10, cell.clustering = NULL, show.cell.dendrogram = TRUE,
  plot = TRUE, box = TRUE, trim = 0, return.details = FALSE, ...)
}
\arguments{
\item{pathways}{character vector of pathway or gene names}

\item{varinfo}{output of pagoda.varnorm()}

\item{goenv}{environment mapping pathways to genes}

\item{n.genes}{number of genes to show}

\item{two.sided}{whether the set of shown genes should be split among highest and lowest loading (T) or if genes with highest absolute loading (F) should be shown}

\item{n.pc}{optional integer vector giving the number of principal component to show for each listed pathway}

\item{colcols}{optional column color matrix}

\item{zlim}{optional z color limit}

\item{showRowLabels}{controls whether row labels are shown in the plot}

\item{cexCol}{column label size (cex)}

\item{cexRow}{row label size (cex)}

\item{nstarts}{number of random starts for the wPCA}

\item{cell.clustering}{cell clustering}

\item{show.cell.dendrogram}{whether cell dendrogram should be shown}

\item{plot}{whether the plot should be shown}

\item{box}{whether to draw a box around the plotted matrix}

\item{trim}{optional Winsorization trim that should be applied}

\item{return.details}{whether the function should return the matrix as well as full PCA info instead of just PC1 vector}

\item{...}{additional arguments are passed to the \code{c.view.pathways}}
}
\value{
cell scores along the first principal component of shown genes (returned as invisible)
}
\description{
Takes in a list of pathways (or a list of genes), runs weighted PCA, optionally showing the result.
}

