% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{pagoda.reduce.redundancy}
\alias{pagoda.reduce.redundancy}
\title{Collapse aspects driven by similar patterns (i.e. separate the same sets of cells)}
\usage{
pagoda.reduce.redundancy(tamr, distance.threshold = 0.2,
  cluster.method = "complete", distance = NULL,
  weighted.correlation = TRUE, plot = FALSE, top = Inf, trim = 0,
  abs = FALSE, ...)
}
\arguments{
\item{tamr}{output of pagoda.reduce.loading.redundancy()}

\item{distance.threshold}{similarity threshold for grouping interdependent aspects}

\item{cluster.method}{one of the standard clustering methods to be used (fastcluster::hclust is used if available or stats::hclust)}

\item{distance}{distance matrix}

\item{weighted.correlation}{Boolean of whether to use a weighted correlation in determining the similarity of patterns}

\item{plot}{Boolean of whether to show plot}

\item{top}{Restrict output to the top n aspects of heterogeneity}

\item{trim}{Winsorization trim to use prior to determining the top aspects}

\item{abs}{Boolean of whether to use absolute correlation}

\item{...}{additional arguments are passed to the pagoda.view.aspects() method during plotting}
}
\value{
a list structure analogous to that returned by pagoda.top.aspects(), but with addition of a $cnam element containing a list of aspects summarized by each row of the new (reduced) $xv and $xvw
}
\description{
Examines PC loading vectors underlying the identified aspects and clusters aspects based on score correlation. Clusters of aspects driven by the same patterns are determined based on the distance.threshold.
}
\examples{
data(pollen)
cd <- clean.counts(pollen)
\donttest{
knn <- knn.error.models(cd, k=ncol(cd)/4, n.cores=10, min.count.threshold=2, min.nonfailed=5, max.model.plots=10)
varinfo <- pagoda.varnorm(knn, counts = cd, trim = 3/ncol(cd), max.adj.var = 5, n.cores = 1, plot = FALSE)
pwpca <- pagoda.pathway.wPCA(varinfo, go.env, n.components=1, n.cores=10, n.internal.shuffles=50)
tam <- pagoda.top.aspects(pwpca, return.table = TRUE, plot=FALSE, z.score=1.96)  # top aspects based on GO only
tamr <- pagoda.reduce.loading.redundancy(tam, pwpca)
tamr2 <- pagoda.reduce.redundancy(tamr, distance.threshold = 0.9, plot = TRUE, labRow = NA, labCol = NA, box = TRUE, margins = c(0.5, 0.5), trim = 0)
}

}

