% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{clean.gos}
\alias{clean.gos}
\title{Filter GOs list}
\usage{
clean.gos(go.env, min.size = 5, max.size = 5000, annot = FALSE)
}
\arguments{
\item{go.env}{GO or gene set list}

\item{min.size}{Minimum size for number of genes in a gene set (default: 5)}

\item{max.size}{Maximum size for number of genes in a gene set (default: 5000)}

\item{annot}{Whether to append GO annotations for easier interpretation (default: FALSE)}
}
\value{
a filtered GO list
}
\description{
Filter GOs list and append GO names when appropriate
}
\examples{
\donttest{
# 10 sample GOs
library(org.Hs.eg.db)
go.env <- mget(ls(org.Hs.egGO2ALLEGS)[1:10], org.Hs.egGO2ALLEGS)
# Filter this list and append names for easier interpretation
go.env <- clean.gos(go.env)
}

}

