% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{clean.counts}
\alias{clean.counts}
\title{Filter counts matrix}
\usage{
clean.counts(counts, min.lib.size = 1800, min.reads = 10,
  min.detected = 5)
}
\arguments{
\item{counts}{read count matrix. The rows correspond to genes, columns correspond to individual cells}

\item{min.lib.size}{Minimum number of genes detected in a cell. Cells with fewer genes will be removed (default: 1.8e3)}

\item{min.reads}{Minimum number of reads per gene. Genes with fewer reads will be removed (default: 10)}

\item{min.detected}{Minimum number of cells a gene must be seen in. Genes not seen in a sufficient number of cells will be removed (default: 5)}
}
\value{
a filtered read count matrix
}
\description{
Filter counts matrix based on gene and cell requirements
}
\examples{
data(pollen)
dim(pollen)
cd <- clean.counts(pollen)
dim(cd)

}

