% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNormalizedReadCounts.R
\name{plotNormalizedReadCounts}
\alias{plotNormalizedReadCounts}
\title{Plot normalized read counts}
\usage{
plotNormalizedReadCounts(sce)
}
\arguments{
\item{sce}{A SingleCellExperiment object containing the relevant data.}
}
\value{
ggplot object visualizing the normalized read counts in a bar chart.
}
\description{
This function plots the normalize read counts in a bar chart.
}
\examples{
# Assume `sce` is a SingleCellExperiment object with 'counts' assay.
h5_file_path <- system.file("extdata", "demo.h5", package = "scafari")
h5 <- h5ToSce(h5_file_path)
sce <- h5$sce_amp
sce <- normalizeReadCounts(sce = sce)
plotNormalizedReadCounts(sce)

}
