% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper-functions.R
\name{createTreeViz}
\alias{createTreeViz}
\title{Creates `TreeViz` object from hierarchy and count matrix}
\usage{
createTreeViz(clusters, counts)
}
\arguments{
\item{clusters}{`ClusterHierarchy` object or a dataframe containing cluster information at different resolutions}

\item{counts}{matrix Dense or sparse matrix containing the count matrix}
}
\value{
`TreeViz`` Object
}
\description{
Provided with a count matrix and a dataframe or `ClusterHierarchy` object, this module 
runs the necessary checks on the dataframe and tries to convert it to a tree by making necessary changes.
Returns the `TreeViz` object if a tree is successfully generated from dataframe, throws error otherwise
}
\examples{
n=64
# create a hierarchy
df<- data.frame(cluster0=rep(1,n))
for(i in seq_len(5)){
  df[[paste0("cluster",i)]]<- rep(seq(1:(2**i)),each=ceiling(n/(2**i)),len=n)
}
# generate a count matrix
counts <- matrix(rpois(6400, lambda = 10), ncol=n, nrow=100)
colnames(counts)<- seq_len(64)
# create a `TreeViz` object
treeViz <- createTreeViz(df, counts)

}
